/*
 * Decompiled with CFR 0.152.
 */
package org.com1028.cw.jm01301;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.com1028.cw.jm01301.DatabaseManager;
import org.com1028.cw.jm01301.Help;
import org.com1028.cw.jm01301.ResultItem;
import org.com1028.cw.jm01301.Snippet;
import org.com1028.cw.jm01301.SortSetting;

public class Window
extends JFrame {
    private static final long serialVersionUID = 3642603350964133628L;
    private int currentSnippetIndex = -1;
    private DatabaseManager databaseManager = null;
    private DefaultListModel<ResultItem> resultsModel = null;
    private ArrayList<Snippet> snippets = null;
    private JMenu about_menu;
    private JMenuItem about_menuItem;
    private JButton clearSearch_btn;
    private JEditorPane code_editor;
    private JScrollPane code_pane;
    private JLabel dateTime_label;
    private JMenuItem deleteSnippet_menuItem;
    private JTextArea description_area;
    private JLabel description_label;
    private JScrollPane description_pane;
    private JMenu file_Menu;
    private JButton go_btn;
    private JMenuItem help_menuItem;
    private JLabel language_label;
    private JTextField language_textField;
    private JMenuBar menuBar;
    private JButton minus_btn;
    private JMenuItem newSnippet_menuItem;
    private JButton plus_btn;
    private JList<ResultItem> resultItem_List;
    private JScrollPane resultItem_pane;
    private JTextField search_textField;
    private JButton sortAsc_btn;
    private JButton sortDes_btn;
    private JComboBox<String> sortSetting_combo;
    private JLabel tags_label;
    private JTextField tags_textField;
    private JTextField title_textField;

    public Window() {
        this.initComponents();
        this.databaseManager = new DatabaseManager(String.valueOf(System.getProperty("user.home")) + "/snippet_manager.db");
        this.snippets = this.databaseManager.loadFromDatabase();
        this.resultsModel = new DefaultListModel();
        this.populateResultSet();
        this.updateResults();
        this.displaySnippet();
    }

    private void initComponents() {
        this.plus_btn = new JButton();
        this.minus_btn = new JButton();
        this.sortSetting_combo = new JComboBox();
        this.sortAsc_btn = new JButton();
        this.sortDes_btn = new JButton();
        this.search_textField = new JTextField();
        this.go_btn = new JButton();
        this.resultItem_pane = new JScrollPane();
        this.resultItem_List = new JList();
        this.clearSearch_btn = new JButton();
        this.description_label = new JLabel();
        this.dateTime_label = new JLabel();
        this.description_pane = new JScrollPane();
        this.description_area = new JTextArea();
        this.language_label = new JLabel();
        this.language_textField = new JTextField();
        this.tags_textField = new JTextField();
        this.tags_label = new JLabel();
        this.title_textField = new JTextField();
        this.code_pane = new JScrollPane();
        this.code_editor = new JEditorPane();
        this.menuBar = new JMenuBar();
        this.file_Menu = new JMenu();
        this.newSnippet_menuItem = new JMenuItem();
        this.deleteSnippet_menuItem = new JMenuItem();
        this.about_menu = new JMenu();
        this.about_menuItem = new JMenuItem();
        this.help_menuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Code Snippet Manager");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Window.this.formWindowClosing(evt);
            }
        });
        this.plus_btn.setFont(new Font("Cantarell", 0, 48));
        this.plus_btn.setText("+");
        this.plus_btn.setToolTipText("New Snippet");
        this.plus_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Window.this.plus_btnActionPerformed(evt);
            }
        });
        this.minus_btn.setFont(new Font("Cantarell", 0, 48));
        this.minus_btn.setText("-");
        this.minus_btn.setToolTipText("Delete Snippet");
        this.minus_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Window.this.minus_btnActionPerformed(evt);
            }
        });
        this.sortSetting_combo.setFont(new Font("Cantarell", 0, 29));
        this.sortSetting_combo.setModel(new DefaultComboBoxModel<String>(new String[]{"Date", "Language", "Title"}));
        this.sortSetting_combo.setSelectedIndex(2);
        this.sortSetting_combo.setToolTipText("Sort Mode");
        this.sortSetting_combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Window.this.sortSetting_comboActionPerformed(evt);
            }
        });
        this.sortAsc_btn.setFont(new Font("DejaVu Sans", 0, 8));
        this.sortAsc_btn.setText("\u25b2");
        this.sortAsc_btn.setToolTipText("Sort Ascending");
        this.sortAsc_btn.setEnabled(false);
        this.sortAsc_btn.setPreferredSize(new Dimension(30, 40));
        this.sortAsc_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Window.this.sortAsc_btnActionPerformed(evt);
            }
        });
        this.sortDes_btn.setFont(new Font("DejaVu Sans", 0, 8));
        this.sortDes_btn.setText("\u25bc");
        this.sortDes_btn.setToolTipText("Sort Descending");
        this.sortDes_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Window.this.sortDes_btnActionPerformed(evt);
            }
        });
        this.search_textField.setFont(new Font("Cantarell", 0, 32));
        this.search_textField.setText("Search");
        this.search_textField.setToolTipText("Search Snippets");
        this.search_textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Window.this.search_textFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                Window.this.search_textFieldFocusLost(evt);
            }
        });
        this.go_btn.setFont(new Font("Cantarell", 0, 32));
        this.go_btn.setText("Go");
        this.go_btn.setToolTipText("Search");
        this.go_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Window.this.go_btnActionPerformed(evt);
            }
        });
        this.resultItem_List.setMaximumSize(new Dimension(258, 764));
        this.resultItem_List.setMinimumSize(new Dimension(258, 764));
        this.resultItem_List.setName("");
        this.resultItem_List.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Window.this.resultItem_ListMouseReleased(evt);
            }
        });
        this.resultItem_pane.setViewportView(this.resultItem_List);
        this.clearSearch_btn.setFont(new Font("Cantarell", 0, 32));
        this.clearSearch_btn.setText("Clear Search");
        this.clearSearch_btn.setToolTipText("Clear search results");
        this.clearSearch_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Window.this.clearSearch_btnActionPerformed(evt);
            }
        });
        this.description_label.setFont(new Font("Cantarell", 0, 29));
        this.description_label.setText("Description:");
        this.dateTime_label.setFont(new Font("Cantarell", 0, 26));
        this.dateTime_label.setText("hh:mm dd/mm/yy");
        this.description_area.setColumns(19);
        this.description_area.setFont(new Font("Cantarell", 0, 29));
        this.description_area.setRows(3);
        this.description_area.setToolTipText("Description of the Snippet");
        this.description_area.setWrapStyleWord(true);
        this.description_area.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Window.this.description_areaKeyReleased(evt);
            }
        });
        this.description_pane.setViewportView(this.description_area);
        this.language_label.setFont(new Font("Cantarell", 0, 29));
        this.language_label.setText("Language:");
        this.language_textField.setFont(new Font("Cantarell", 0, 29));
        this.language_textField.setToolTipText("Programming Language");
        this.language_textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Window.this.language_textFieldKeyReleased(evt);
            }
        });
        this.tags_textField.setFont(new Font("Cantarell", 0, 29));
        this.tags_textField.setToolTipText("Tags are used to find Snippets");
        this.tags_textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Window.this.tags_textFieldFocusLost(evt);
            }
        });
        this.tags_label.setFont(new Font("Cantarell", 0, 29));
        this.tags_label.setText("Tags:");
        this.title_textField.setFont(new Font("Cantarell", 0, 27));
        this.title_textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Window.this.title_textFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                Window.this.title_textFieldFocusLost(evt);
            }
        });
        this.title_textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Window.this.title_textFieldKeyReleased(evt);
            }
        });
        this.code_editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Window.this.code_editorKeyReleased(evt);
            }
        });
        this.code_pane.setViewportView(this.code_editor);
        this.file_Menu.setText("File");
        this.newSnippet_menuItem.setText("New Snippet");
        this.newSnippet_menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Window.this.newSnippet_menuItemActionPerformed(evt);
            }
        });
        this.file_Menu.add(this.newSnippet_menuItem);
        this.deleteSnippet_menuItem.setText("Delete Snippet");
        this.deleteSnippet_menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Window.this.deleteSnippet_menuItemActionPerformed(evt);
            }
        });
        this.file_Menu.add(this.deleteSnippet_menuItem);
        this.menuBar.add(this.file_Menu);
        this.about_menu.setText("About");
        this.about_menuItem.setText("About");
        this.about_menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Window.this.about_menuItemActionPerformed(evt);
            }
        });
        this.about_menu.add(this.about_menuItem);
        this.help_menuItem.setText("Help");
        this.help_menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Window.this.help_menuItemActionPerformed(evt);
            }
        });
        this.about_menu.add(this.help_menuItem);
        this.menuBar.add(this.about_menu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.plus_btn, -2, 66, -2).addGap(18, 18, 18).addComponent(this.minus_btn, -2, 66, -2).addGap(18, 18, 18).addComponent(this.sortSetting_combo, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sortAsc_btn, -2, 40, -2).addComponent(this.sortDes_btn, -2, 40, -2)).addGap(81, 81, 81).addComponent(this.search_textField, -2, 420, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.go_btn, -1, 54, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.clearSearch_btn, -1, -1, Short.MAX_VALUE).addComponent(this.resultItem_pane, -2, 258, -2)).addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.language_label).addComponent(this.tags_label)).addGap(35, 35, 35)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.description_label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.language_textField).addComponent(this.tags_textField).addComponent(this.description_pane))).addGroup(layout.createSequentialGroup().addComponent(this.title_textField, -2, 338, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.dateTime_label)).addComponent(this.code_pane, GroupLayout.Alignment.TRAILING)))).addGap(22, 22, 22)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.sortAsc_btn, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sortDes_btn, -2, 30, -2)).addComponent(this.sortSetting_combo).addComponent(this.plus_btn, -2, 66, -2).addComponent(this.minus_btn, -2, 66, -2).addComponent(this.search_textField).addComponent(this.go_btn, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.title_textField, -2, 60, -2).addComponent(this.dateTime_label)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.code_pane, -2, 511, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.description_label).addComponent(this.description_pane, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.language_label).addComponent(this.language_textField, -2, -1, -2))).addComponent(this.resultItem_pane, -2, 764, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tags_textField, -2, -1, -2).addComponent(this.tags_label).addComponent(this.clearSearch_btn)).addGap(22, 22, 22)));
        this.pack();
    }

    private void plus_btnActionPerformed(ActionEvent evt) {
        this.createNewSnippet();
    }

    private void minus_btnActionPerformed(ActionEvent evt) {
        this.deleteSnippet();
    }

    private void sortSetting_comboActionPerformed(ActionEvent evt) {
        this.sortSnippets(this.getSortSetting(), this.sortDes_btn.isEnabled());
    }

    private void sortAsc_btnActionPerformed(ActionEvent evt) {
        this.sortAsc_btn.setEnabled(false);
        this.sortDes_btn.setEnabled(true);
        this.sortSnippets(this.getSortSetting(), this.sortDes_btn.isEnabled());
    }

    private void sortDes_btnActionPerformed(ActionEvent evt) {
        this.sortAsc_btn.setEnabled(true);
        this.sortDes_btn.setEnabled(false);
        this.sortSnippets(this.getSortSetting(), this.sortDes_btn.isEnabled());
    }

    private void go_btnActionPerformed(ActionEvent evt) {
        this.searchSnippets(this.search_textField.getText());
    }

    private void resultItem_ListMouseReleased(MouseEvent evt) {
        this.selectSnippet();
        this.displaySnippet();
    }

    private void title_textFieldKeyReleased(KeyEvent evt) {
        this.editTitle();
    }

    private void description_areaKeyReleased(KeyEvent evt) {
        this.editDescription();
    }

    private void language_textFieldKeyReleased(KeyEvent evt) {
        this.editLanguage();
    }

    private void clearSearch_btnActionPerformed(ActionEvent evt) {
        this.clearSearch();
    }

    private void tags_textFieldFocusLost(FocusEvent evt) {
        this.editTags();
    }

    private void search_textFieldFocusLost(FocusEvent evt) {
        String term = this.search_textField.getText();
        if (term.equals("")) {
            this.search_textField.setText("Search");
        }
    }

    private void search_textFieldFocusGained(FocusEvent evt) {
        String term = this.search_textField.getText();
        if (term.equals("Search")) {
            this.search_textField.setText("");
        }
    }

    private void newSnippet_menuItemActionPerformed(ActionEvent evt) {
        this.createNewSnippet();
    }

    private void deleteSnippet_menuItemActionPerformed(ActionEvent evt) {
        this.deleteSnippet();
    }

    private void about_menuItemActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Snippet Manager\nCOM1028 Coursework\n2018 Jamie Munro, All Rights Reserved\njm01301@surrey.ac.uk", "About", 1);
    }

    private void help_menuItemActionPerformed(ActionEvent evt) {
        Help.main();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.databaseManager.saveToDatabase(this.snippets);
    }

    private void title_textFieldFocusGained(FocusEvent evt) {
        String title = this.title_textField.getText();
        if (title.equals("New Snippet")) {
            this.title_textField.setText("");
        }
    }

    private void title_textFieldFocusLost(FocusEvent evt) {
        String title = this.title_textField.getText();
        if (title.equals("")) {
            this.title_textField.setText("New Snippet");
        }
    }

    private void code_editorKeyReleased(KeyEvent evt) {
        this.editCode();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Window().setVisible(true);
            }
        });
    }

    private void createNewSnippet() {
        this.snippets.add(new Snippet("New Snippet", "", "", "", new Date(), ""));
        this.currentSnippetIndex = this.snippets.size() - 1;
        this.displaySnippet();
        this.populateResultSet();
        this.updateResults();
        this.setSelected();
        this.minus_btn.setEnabled(true);
    }

    private void deleteSnippet() {
        this.snippets.remove(this.currentSnippetIndex);
        int currentListIndex = this.resultItem_List.getSelectedIndex();
        this.populateResultSet();
        this.updateResults();
        int newListIndex = currentListIndex - 1;
        if (newListIndex < 0) {
            newListIndex = this.resultsModel.getSize() > 0 ? 0 : -1;
        } else if (newListIndex > this.resultsModel.getSize()) {
            newListIndex = this.resultsModel.getSize();
        }
        this.resultItem_List.setSelectedIndex(newListIndex);
        this.selectSnippet();
        this.displaySnippet();
    }

    private void editTitle() {
        String newTitle = this.title_textField.getText();
        this.snippets.get(this.currentSnippetIndex).setTitle(newTitle);
        this.populateResultSet();
        this.updateResults();
    }

    private void editLanguage() {
        String newLanguage = this.language_textField.getText();
        this.snippets.get(this.currentSnippetIndex).setLanguage(newLanguage);
    }

    private void editDescription() {
        String newDescription = this.description_area.getText();
        this.snippets.get(this.currentSnippetIndex).setDescription(newDescription);
        this.populateResultSet();
        this.updateResults();
    }

    private void editCode() {
        String newCode = this.code_editor.getText();
        this.snippets.get(this.currentSnippetIndex).setCode(newCode);
    }

    private void editTags() {
        String tagStr = this.tags_textField.getText();
        String[] tags = tagStr.split(",");
        boolean valid = true;
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (tag.contains(" ") || tag.equals("")) {
                valid = false;
                break;
            }
            ++n2;
        }
        if (valid) {
            this.snippets.get(this.currentSnippetIndex).setTags(tagStr);
        } else {
            JOptionPane.showMessageDialog(this, "The tag field must contain a comma seperated list of tags with nospaces and no trailing comma.\nExample: \"hello,world,introduction,easy\"", "Error", 0);
            this.tags_textField.setText(this.snippets.get(this.currentSnippetIndex).getTags());
        }
    }

    private void searchSnippets(String term) {
        ArrayList<Snippet> results = new ArrayList<Snippet>();
        for (Snippet snippet : this.snippets) {
            String[] tags;
            if (snippet.getTitle().toUpperCase().contains(term.toUpperCase())) {
                results.add(snippet);
                continue;
            }
            if (snippet.getLanguage().toUpperCase().contains(term.toUpperCase())) {
                results.add(snippet);
                continue;
            }
            String tagStr = snippet.getTags();
            String[] stringArray = tags = tagStr.split(",");
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (tag.toUpperCase().contains(term.toUpperCase())) {
                    results.add(snippet);
                }
                ++n2;
            }
        }
        this.resultsModel = new DefaultListModel();
        int i = 0;
        while (i < this.snippets.size()) {
            if (results.contains(this.snippets.get(i))) {
                Snippet snippet = this.snippets.get(i);
                ResultItem item = new ResultItem(i, snippet.getTitle(), snippet.getLanguage(), snippet.getDateCreated());
                this.resultsModel.addElement(item);
            }
            ++i;
        }
        this.updateResults();
    }

    private void clearSearch() {
        this.populateResultSet();
        this.search_textField.setText("Search");
    }

    private SortSetting getSortSetting() {
        SortSetting setting = null;
        switch (this.sortSetting_combo.getSelectedIndex()) {
            case 0: {
                setting = SortSetting.DATE;
                break;
            }
            case 1: {
                setting = SortSetting.PROGRAMMING_LANGUAGE;
                break;
            }
            case 2: {
                setting = SortSetting.TITLE;
            }
        }
        return setting;
    }

    private void sortSnippets(SortSetting setting, boolean ascending) {
        ArrayList<ResultItem> resultSet = Collections.list(this.resultsModel.elements());
        switch (setting) {
            case DATE: {
                Collections.sort(resultSet, (r1, r2) -> r1.getDateCreated().compareTo(r2.getDateCreated()));
                if (ascending) break;
                Collections.reverse(resultSet);
                break;
            }
            case PROGRAMMING_LANGUAGE: {
                Collections.sort(resultSet, (r1, r2) -> r1.getLanguage().toUpperCase().compareTo(r2.getLanguage().toUpperCase()));
                if (ascending) break;
                Collections.reverse(resultSet);
                break;
            }
            case TITLE: {
                Collections.sort(resultSet, (r1, r2) -> r1.getTitle().toUpperCase().compareTo(r2.getTitle().toUpperCase()));
                if (ascending) break;
                Collections.reverse(resultSet);
            }
        }
        this.resultsModel.clear();
        for (ResultItem item : resultSet) {
            this.resultsModel.addElement(item);
        }
        this.updateResults();
    }

    private void populateResultSet() {
        this.resultsModel = new DefaultListModel();
        int i = 0;
        while (i < this.snippets.size()) {
            Snippet snippet = this.snippets.get(i);
            ResultItem item = new ResultItem(i, snippet.getTitle(), snippet.getLanguage(), snippet.getDateCreated());
            this.resultsModel.addElement(item);
            ++i;
        }
        this.sortSnippets(this.getSortSetting(), this.sortDes_btn.isEnabled());
    }

    private void displaySnippet() {
        if (this.currentSnippetIndex > -1) {
            Snippet snippet = this.snippets.get(this.currentSnippetIndex);
            this.title_textField.setText(snippet.getTitle());
            this.title_textField.setEnabled(true);
            String date = new SimpleDateFormat("hh:mm dd/MM/yyyy").format(snippet.getDateCreated());
            this.dateTime_label.setText(date);
            this.code_editor.setText(snippet.getCode());
            this.code_editor.setEnabled(true);
            this.description_area.setText(snippet.getDescription());
            this.description_area.setEnabled(true);
            this.language_textField.setText(snippet.getLanguage());
            this.language_textField.setEnabled(true);
            this.tags_textField.setText(snippet.getTags());
            this.tags_textField.setEnabled(true);
        } else {
            this.title_textField.setText(" ");
            this.title_textField.setEnabled(false);
            this.dateTime_label.setText(" ");
            this.code_editor.setText(" ");
            this.code_editor.setEnabled(false);
            this.description_area.setText(" ");
            this.description_area.setEnabled(false);
            this.language_textField.setText(" ");
            this.language_textField.setEnabled(false);
            this.tags_textField.setText(" ");
            this.tags_textField.setEnabled(false);
        }
    }

    private void updateResults() {
        this.resultItem_List.setModel(this.resultsModel);
        if (this.snippets.size() < 1) {
            this.minus_btn.setEnabled(false);
        }
    }

    private void selectSnippet() {
        int index = this.resultItem_List.getSelectedIndex();
        if (index > -1) {
            ResultItem item = this.resultsModel.getElementAt(index);
            this.currentSnippetIndex = item.getSnippetIndex();
        } else {
            this.currentSnippetIndex = -1;
        }
    }

    private void setSelected() {
        int i = 0;
        while (i < this.resultsModel.getSize()) {
            ResultItem item = this.resultsModel.getElementAt(i);
            if (this.currentSnippetIndex == item.getSnippetIndex()) {
                this.resultItem_List.setSelectedIndex(i);
            }
            ++i;
        }
    }
}

