/*
 * Decompiled with CFR 0.152.
 */
package org.com1028.cw.jm01301;

import java.util.Date;
import org.com1028.cw.jm01301.Snippet;
import org.junit.Assert;
import org.junit.Test;

public class SnippetTest {
    @Test
    public void testSnippetCreate() {
        Date today = new Date();
        Snippet snippet = new Snippet("New snippet", "code", "description", "language", today, "tags");
        Assert.assertEquals(snippet.getTitle(), "New snippet");
        Assert.assertEquals(snippet.getCode(), "code");
        Assert.assertEquals(snippet.getDescription(), "description");
        Assert.assertEquals(snippet.getLanguage(), "language");
        Assert.assertEquals(snippet.getDateCreated(), today);
        Assert.assertEquals(snippet.getTags(), "tags");
    }

    @Test
    public void testSnippetSetters() {
        Date today = new Date();
        Snippet snippet = new Snippet("", "", "", "", today, "");
        snippet.setTitle("new title");
        Assert.assertEquals(snippet.getTitle(), "new title");
        snippet.setCode("new code");
        Assert.assertEquals(snippet.getCode(), "new code");
        snippet.setDescription("new description");
        Assert.assertEquals(snippet.getDescription(), "new description");
        snippet.setLanguage("new language");
        Assert.assertEquals(snippet.getLanguage(), "new language");
        snippet.setTags("new tags");
        Assert.assertEquals(snippet.getTags(), "new tags");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidCreation() {
        Snippet snippet = new Snippet(null, null, null, null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidTitle() {
        Date today = new Date();
        Snippet snippet = new Snippet("New snippet", "code", "description", "language", today, "tags");
        snippet.setTitle(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidCode() {
        Date today = new Date();
        Snippet snippet = new Snippet("New snippet", "code", "description", "language", today, "tags");
        snippet.setCode(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidDescription() {
        Date today = new Date();
        Snippet snippet = new Snippet("New snippet", "code", "description", "language", today, "tags");
        snippet.setDescription(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidLanguage() {
        Date today = new Date();
        Snippet snippet = new Snippet("New snippet", "code", "description", "language", today, "tags");
        snippet.setLanguage(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidTags() {
        Date today = new Date();
        Snippet snippet = new Snippet("New snippet", "code", "description", "language", today, "tags");
        snippet.setTags(null);
    }
}

